<?php
/* class.antibot.php 
.---------------------------------------------------------------------------.
|  Software: AntiBot - PHP form class                                       |
|   Version: 2                                                              |
|      Site: http://jspit.de/?page=antibot                                  |
| ------------------------------------------------------------------------- |
| Copyright (c) 2012, Peter Junk. All Rights Reserved.                      |
| ------------------------------------------------------------------------- |
|   License: Distributed under the Lesser General Public License (LGPL)     |
|            http://www.gnu.org/copyleft/lesser.html                        |
| This program is distributed in the hope that it will be useful - WITHOUT  |
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     |
| FITNESS FOR A PARTICULAR PURPOSE.                                         |
'---------------------------------------------------------------------------'
*/

class AntiBot {
  //min + max. Zeit fuer Formular 
	private $maxformtime = "20 Minutes"; //max Zeit für Formulareingebe
	private $minformtime = "5 seconds";  //min Zeit für Formulareingabe
	private $liveTime = '1 Hour';  //zusätzliche Zeit für die Speicherung alter Daten
  private $saveNotValid = true;   //ungültige Einträge für liveTime behalten
  
	//
  private $name;
  private $name2;
	private $cache;
  private $infos;
  
  private $IdentDescription ="";  
  
  public function __construct($name,cacheInterfaceAll $cache) {
    $this -> name = $name;
    $this -> name2 = $name.'_2';
    $this -> cache = $cache;
    //
    $cache -> lock();
    $infos = $cache -> get($name);
    debug::write('Anzahl Einträge',count($infos));
    //alte Einträge löschen
    $delDatum = date_create('Now -'.$this->liveTime.' -'.$this->maxformtime);
    $newInfos = array();
    if(!empty($infos)) {
      foreach($infos as $id => $info) {
        if(($this->saveNotValid || $info['valid']) &&
           date_create($info['time']) >= $delDatum) {
          $newInfos[$id] = $info;
        }
      }
    }
    $this -> infos = $newInfos;
    $cache -> set($name,$newInfos);
    $cache -> unlock();
  }
  
  //Zeitfenster für das Formular setzen
  public function setTimeSlot($minformtime = null, $maxformtime = null) {
    if(Date_Create('2000-1-1 '.$minformtime) === false ||
       Date_Create('2000-1-1 '.$maxformtime) === false) return false;
    if($minformtime !== null) $this -> minformtime = $minformtime;
    if($maxformtime !== null) $this -> maxformtime = $maxformtime;
    return true;
  }

  //liefert HTML + js für das Formular
  public function getProtectorInput() {
    $name = $this -> name;
    $name2 = $this -> name2;
    //neuen Eintrag erzeugen
    $cache = $this -> cache;
    $cache -> lock();
    $allInfos = $cache -> get($name);
    do {
      $id = 't'.rand(100000,999999);
    } while (array_key_exists($id,$allInfos));
    $infos = array(
      //'ip' => $_SERVER['REMOTE_ADDR'],
      'time' => date("Y-m-d H:i:s"),
      'valid' => true,
    );
    $allInfos[$id] = $infos;
    $cache -> set($name,$allInfos);
    $cache -> unlock();
    //HTML + js 
    $html = '<input name="'.$name.'" id="Id_'.$name.'" type="text" value="your mail" />';
    $html .= '<script type="text/javascript">
     (function() {
        var el = document.getElementById("Id_'.$name.'");
        el.value = "";
        el.style.display="none";
        var newNode = el.cloneNode(true);
        newNode.setAttribute("name","'.$name2.'");
        newNode.setAttribute("id","Id_'.$name2.'");
        newNode.value = "'.$id.'";
        el.parentNode.insertBefore(newNode, el);
      })();
    </script>';
    return $html;
  }
  
 	//Liefert Info, ob die Form gesendet wurde
  //Form wurde gesendet, Formularfeld $name vorhanden ist
	public function isFormSend() {
    return isset($_POST[$this->name]);
	}
  
  //
  public function isBot($setIdInvalid = true) {
    if(!$this->isFormSend()) return false; //kein formular gesendet
    
    //per js erzeugtes Input vorhanden ?
    if(! isset($_POST[$this->name2])) {
      $this -> IdentDescription = 'Second Protector-Input not exists';  
      return true;
    }

    //protector-Feld gefüllt ?
    if($_POST[$this->name] !== '') {
      $this -> IdentDescription = 'Protector-Input filled';  
      return true;
    }

    //ID valid ?
    $id = $_POST[$this->name2];
    //format validieren
    if(! preg_match('/^t\d{6}$/',$id)) {
      $this -> IdentDescription = 'Invalid Format Protector-Id';  
      return true;
    }
    if(! array_key_exists($id, $this->infos) ) {
      $this -> IdentDescription = 'Not found Protector-Id';  
      return true;
    }
    $infos = $this->infos;
    $info = $infos[$id];
    if(!$info['valid']){
      $this -> IdentDescription = 'Invalid Protector-Id';  
      return true;
    }
    
    //Id als verbraucht markieren
    if($setIdInvalid) $this -> setIdValid($id,false);
    
    //Zeitbedingungen testen
    $d = $this -> minformtime;
    if(date_create('Now') < date_create($info['time'].' +'.$d)) {
      $this -> IdentDescription = 'Response-Time < '.$d;  
      return true;
    }

    $d = $this -> maxformtime;
    if(date_create('Now') > date_create($info['time'].' +'.$d)) {
      $this -> IdentDescription = 'Response-Time > '.$d;  
      return true;
    }
    
    //HTTP Referer testen
    if(! $this->validate_http_referer()) {
      $this -> IdentDescription = 'Invalid HTTP Referer';
      return true;      
    }
    return false;
  }
  
  /*
   * Liefert eine Beschreibung der Maßnahme, welche zur Identifizierung geführt hat
   * Achtung: Nur zu Debugging-Zwecken nutzen
   */
  public function getIdentDescription() {
    return $this -> IdentDescription;
  }
  
  /*
   * private
   */
   
  /*
   * Die Rückgabe von validate_http_referer ist false, wenn kein HTTP_REFERER existiert
   * oder von einem fremden Host kommt, sonst true
   */
  private function validate_http_referer() {
    if(isset($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST'])) {
      if(parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST)==$_SERVER['HTTP_HOST']) return true;
    }
  return false;
  }   
  
 
  private function setIdValid($id,$b = true) {
    $cache = $this -> cache;
    $cache -> lock();
    $allInfos = $cache -> get($this->name);
    if(isset($allInfos[$id])) {
      $allInfos[$id]['valid'] = $b;
      $cache -> set($this->name,$allInfos);
    }
    $cache -> unlock();
  }
}
?>
